package imagem;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.imageio.ImageIO;

public class Imagem {
	
	private BufferedImage imagem;
    private int largura;
    private int altura;
    int[][][] matriz;
    
    public Imagem(){}
    
	public BufferedImage getImagem() {
		return imagem;
	}
	public void setImagem(BufferedImage imagem) {
		this.imagem = imagem;
	}
	public int getLargura() {
		return largura;
	}
	public void setLargura(int largura) {
		this.largura = largura;
	}
	public int getAltura() {
		return altura;
	}
	public void setAltura(int altura) {
		this.altura = altura;
	}
	public int[][][] getMatriz() {
		return matriz;
	}
	public void setMatriz(int[][][] matriz) {
		this.matriz = matriz;
	}
	
	
	public void lerMatriz() {
        for (int linha = 0; linha < matriz.length; linha++) {
            for (int coluna = 0; coluna < matriz[linha].length; coluna++) {
                int r = matriz[linha][coluna][0];
                int g = matriz[linha][coluna][1];
                int b = matriz[linha][coluna][2];
                Color pixel = new Color(r, g, b);
                getImagem().setRGB(linha, coluna, pixel.getRGB());
            }
        }
    }
	
	public Imagem(String arquivo) {
        try {
            imagem = ImageIO.read(new File(arquivo));
            largura = getImagem().getWidth();
            altura = getImagem().getHeight();
            matriz = new int[largura][altura][3];
            for (int linha = 0; linha < altura; linha++) {
                for (int coluna = 0; coluna < largura; coluna++) {
                    Color pixel = new Color(getImagem().getRGB(coluna, linha));
                    matriz[coluna][linha][0] = pixel.getRed();
                    matriz[coluna][linha][1] = pixel.getGreen();
                    matriz[coluna][linha][2] = pixel.getBlue();
                }
            }
        } catch (IOException ex) {
            Logger.getLogger(Imagem.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
	
	public int[][][] copiaMatriz(){
		
		int[][][] copia = new int[matriz.length][matriz[0].length][matriz[0][0].length];
		
		for(int linha = 0; linha < matriz.length; linha++)
			for(int coluna = 0; coluna < matriz[linha].length; coluna++)
				for(int cor = 0; cor < matriz[linha][coluna].length; cor++)
				copia[linha][coluna][cor] = matriz[linha][coluna][cor];
		
		return copia;
	}

}
